using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;

using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX.DirectPlay;
using Microsoft.DirectX.DirectInput;

using DarkStrideToolbox;
using DarkStride.StellarLanes.SharedDLL;

#region Things to do...
//add an experiance progress bar
//Add a cancel connect button
//Button to leave loot names on
//Highlights don't properly show available locations... what if you have to move the battery to put the lazer there?
//Background music
//Add com system so enemies can mock you 
//Move "Server lost" message into the game
//Add network logging to the network wrapper tied into the game engine debug
//Make items in the editor have a clip range of the inventory area - Do this by preventing you from dropping peices outside the valid spots and by auto-moving them in
//Have session throw event to raise resume menu
//Re-add gravity bleeding code, and move into the entity.
//Write orbit code
//Make dead peices be destroyable
//Other player isn't seeing blue from shield
//Flame coming out old deralict ship
//Add improved regions for main urquan hull
//Quadrent the board of entities so can improve collision time
//Radar is very ineffecient even if you don't draw the missile items.  Need to not iterate them
//Fix //Chris SortedList Index 0 Null Problem
//Missile collision sphere goes ahead of missile
//Add all our ships current chassis back into the stack when we die, and extract the parts to build a new one
//Add "Server just closed your session" message
//find a way to seperate the session objects... use GUIless flag?
//split rendering of world into its own function I think... it just doesn't apply very well in here.  Current problem is how do you line up the grid???
#endregion
#region Names for something or other
//Viceroy
//Chanclor
//Hegmony
#endregion
#region Module types to support
//Orange alerts (Engines at 70% output)
//Effeciency at levels of output
//Fuel
//Lasers (like real life, i.e. instantanious) 
//Laser blast (like star wars) 
//All weapon systems in Star Control II 
//Cloaking device (harder than you'd think) 
//Star Trek Interphase device 
//Holo generator 
//Shields 
//Cargo 
//Launch bays 
//mass drivers
//untargitable things
//A missile shooter downer
//Tractor beams
//Add shields 
#endregion
#region Color Replacement Code
/*
int[,] colori = null;
//int nMaxX = (int)DSMisc.Min( 255,oLoadedTexture.UnModifiedSize.X );
//int nMaxY = (int)DSMisc.Min( 255,oLoadedTexture.UnModifiedSize.Y );
colori = (int[,])oTexture.oTexture.LockRectangle( typeof(int),0,LockFlags.ReadOnly,new int[]{oNewSrcRect.Width,oNewSrcRect.Height} );

for( int i=0 ; i<oNewSrcRect.Width ; i++)
{
	for( int j=0 ; j<oNewSrcRect.Height ; j++ )
	{
		colori[i, j] = System.Drawing.Color.Black.ToArgb();// Color.FromArgb(i, j, 0).ToArgb();
	}
}
oTexture.oTexture.UnlockRectangle(0);
*/
#endregion

namespace DarkStride.StellarLanes.Client
{
	public class frmMain : DSWinForm
    {
		#region Properties
		private bool m_bIHaveJoined = false;
		private bool m_bHostHasJoined = false;

		private double m_nTimeSinceLastSwag = 0;
		private DSGameEngine m_oGameEngine = null;
		private DSSortedList m_oPlayerSocketIDToSessionGUIDLookup = new DSSortedList();

		//Chat room
		private FileDownloader m_oFileDownloader = null;

		//Loading 
		private enumStates m_nGameState = enumStates.LoadingApp;
		private DarkStrideIntro m_oDSIntro = null;
		private Thread m_oLoadingThread = null;
		private double m_nGobLoadingProgress = 0;
		private double m_nFadeAmount = 1;
		private DateTime m_dtLoadingScreenPeriodStartTime = DateTime.MinValue;
		private DateTime m_dtTimeSinceLastSessionUpdate = DateTime.MinValue;

		//Game play
		private Profile m_oProfile = null;
		private Session m_oSession = null;
		private DSSortedList m_oEntitysRemoved = new DSSortedList();

		private DateTime m_dtTimeSinceLastVolumeChangeClick = DateTime.Now;

		//INI Stuff
		private int m_nVolume = 100;
		private bool m_bMuted = false;
		private bool m_bFullscreen = false;
        private bool m_bFullscreenSettingToSave = false;
		private string m_sResolution = string.Empty;
		private string m_sLastUsedIP = string.Empty;

		//Options menu tracking
		private bool m_bStartedOptionsFromInGameResumeMenu = false;
		private bool m_bStartedProfileSelectFromConnectMenu = true;

		//Menu stuff
		private Starscape m_oStarscape = null;
		private double m_nStarMotionAngle = 0;
		private double m_nStarMotionMagnitude = 0;
		#endregion

		#region System Stuff

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(frmMain));
            this.SuspendLayout();
            // 
            // frmMain
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(1016, 741);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Name = "frmMain";
            this.Text = "Stellar Lanes Client";
            this.Closing += new System.ComponentModel.CancelEventHandler(this.frmMain_Closing);
            this.Load += new System.EventHandler(this.frmMain_Load);
            this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			try
			{
				using( frmMain oApp = new frmMain() )
				{                
					oApp.DSGameEngine = new DSGameEngine( oApp,"",true );
					oApp.DSGameEngine.OneTimeSceneInitialization += new EventHandler( oApp.OneTimeSceneInitialization );
					oApp.DSGameEngine.SetDeviceSettings += new EventHandler( oApp.SetDeviceSettings );
					oApp.DSGameEngine.SetRenderStates += new EventHandler( oApp.SetRenderStates );
					oApp.DSGameEngine.Run();
				}
			}
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( oEx );
			}
		}
		#endregion


		private void frmMain_Load(object sender, System.EventArgs e)
		{
			Globals.Inst().PrimaryKey = new DSNetPrimaryKeyGenerator( DSNetPrimaryKeyGenerator.Empty );

			//Now go through and show all the services available
			m_oGameEngine.DirectPlay.Initialize( MiscConstants.m_cAPPGUID,System.Net.Sockets.ProtocolType.Udp );
		}
		private void frmMain_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
            SaveINIFile();

			if( Globals.Inst().Profile != null )
			{
				Globals.Inst().Profile.SaveToFile( true );
			}

			//Do we have pending files downloaded but not deployed?  Fix that.
			if( m_oFileDownloader != null && m_oFileDownloader.DownloadingSuccessful == true )
			{
				m_oFileDownloader.ReplaceExecutables( false );
				m_oFileDownloader = null;
			}

			if( m_oGameEngine.DirectPlay.Connected == true )
			{
				m_oGameEngine.DirectPlay.QuitGame();
			}
		}
        
		#region App Functions
		public void OneTimeSceneInitialization(object sender, System.EventArgs e)
		{
			Microsoft.DirectX.Direct3D.Font oNewFont = null;


            DSBufferDebug.Inst().DebugPath = DSMisc.GetDevelopmentAppPath() +
                                             "DSGameEngine_DebugFile_" +
                                             DateTime.Now.ToString("yyyy-MM-dd hh") + "h" +
                                             DateTime.Now.ToString("mm") + "m" +
                                             DateTime.Now.ToString("ss") + "s" +
                                             ".OUT";

			//Register our callback functions so we know when the engine wants us to do things... consider 
			//deligates/callbacks to be equivilant to VB events.
			m_oGameEngine.RenderBeforeForms += new EventHandler( this.RenderBeforeForms );
			m_oGameEngine.FrameMove += new EventHandler( this.Advance );
			this.Resize += new EventHandler( this.StellarLanes_Resize );

			//Initialize the network connections
			m_oGameEngine.DirectPlay.RegisterDelegate_DataReceived( new DSNetworkWrapper.CallbackDataReceived( this.DataReceived ) );
			m_oGameEngine.DirectPlay.RegisterDelegate_PlayerJoined( new DSNetworkWrapper.CallbackPlayerJoined( this.PlayerJoined ) );
			m_oGameEngine.DirectPlay.RegisterDelegate_PlayerQuit( new DSNetworkWrapper.CallbackPlayerQuit( this.PlayerQuit ) );
			m_oGameEngine.DirectPlay.RegisterDelegate_GameListUpdate( new DSNetworkWrapper.CallbackGameListUpdate( this.GameListUpdate ) );
			m_oGameEngine.DirectPlay.RegisterDelegate_Connection( new DSNetworkWrapper.CallbackConnection( this.Connection ) );

			//Input time!
			m_oGameEngine.DirectInput.RegisterDelegate_MouseMoved( new DSInputWrapper.CallbackMouseMoved( this.DIMouseMoved ) );
			m_oGameEngine.DirectInput.RegisterDelegate_MouseDown( new DSInputWrapper.CallbackMouseDown( this.DIMouseDown ) );
			m_oGameEngine.DirectInput.RegisterDelegate_MouseUp( new DSInputWrapper.CallbackMouseUp( this.DIMouseUp ) );
			m_oGameEngine.DirectInput.RegisterDelegate_KeyboardKeyDown( new DSInputWrapper.CallbackKeyboardKeyDown( this.DIKeyboardKeyDown ) );
			m_oGameEngine.DirectInput.RegisterDelegate_KeyboardKeyUp( new DSInputWrapper.CallbackKeyboardKeyUp( this.DIKeyboardKeyUp ) );

			//Load our font
			oNewFont = new Microsoft.DirectX.Direct3D.Font(
				m_oGameEngine.Direct3DDevice, 14, 0, FontWeight.Regular,
				1, false, CharacterSet.Default, Precision.Default, FontQuality.Default, 
				PitchAndFamily.DefaultPitch | PitchAndFamily.FamilyDoNotCare,"Aetherfox" );
			DSResourceManager.GetGlobalInstance().AddFont( GraphicConstants.m_cSLFONT,oNewFont );

			//Load our big font
			oNewFont = new Microsoft.DirectX.Direct3D.Font(
				m_oGameEngine.Direct3DDevice, 50, 0, FontWeight.Regular,
				1, false, CharacterSet.Default, Precision.Default, FontQuality.Default, 
				PitchAndFamily.DefaultPitch | PitchAndFamily.FamilyDoNotCare,"Aetherfox" );
			DSResourceManager.GetGlobalInstance().AddFont( GraphicConstants.m_cSLFONTBIG,oNewFont );

			//Setup our network
			NetMsg.StopObsoletePackets( m_oGameEngine.DirectPlay );

			m_oGameEngine.MaxFPS = 30;

            SetupSound();
            SetupVideo();
		}
		private void LoadingGOBThread()
		{
            string sFileName = string.Empty;
			DSGobFile oGobFile = null;


			//Get our graphics
			oGobFile = new DSGobFile();
			oGobFile.LoadProgress += new EventHandler( this.GobFile_LoadingProgress );

            if (System.Diagnostics.Debugger.IsAttached == true)
            {
                sFileName = DSMisc.GetDevelopmentAppPath() + @"..\StellarLanes.gob";
            }
            else
            {
                sFileName = DSMisc.GetDevelopmentAppPath() + @"StellarLanes.gob";
            }
            if (System.IO.File.Exists(sFileName) == false)
            {
                MessageBox.Show("The file <" + sFileName + "> does not exist.  This file is required to play the game.", "Load Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                this.Close();
            }
            else
            {
                oGobFile.LoadGobFile(sFileName, GobConstants.m_cGOBNAME);
            }

			//Load in our menus
			m_oGameEngine.Forms.LoadFromStream( oGobFile.GetTable( GobConstants.m_cTABLE_FORMS ).File );
			InitMenuEvents();

			m_oGameEngine.MaxFPS = 50;
			//m_oGameEngine.MaxFPS = 0;
			m_nGobLoadingProgress = 1;
		}
		private void GobFile_LoadingProgress(object sender, System.EventArgs e)
		{
			DSLoadProgressEventArgs oProgress = (DSLoadProgressEventArgs)e;

			//We will manualy set it to 100% when we are ready.  This kicks off the menu loading
			//but first we have to take the GOB data and use it to load the menus
			if( oProgress.Progress < 1 )
			{
				m_nGobLoadingProgress = oProgress.Progress;
			}
		}

		public void SetDeviceSettings(object sender, System.EventArgs e)
		{
			DSINIFile oINIFile = null;
			string sResolution = "";
			string[] saResolution = null;
			long nWidth = 0;
			long nHeight = 0;
			bool bUseDefaultRes = false;


            //Open up the INI file and load in our settings
            LoadINIFile();


			oINIFile = new DSINIFile();
			oINIFile.OpenINIFile( DSMisc.GetDevelopmentAppPath() + INIFileConstants.m_cINIFILENAME,false );

			m_oGameEngine.FullScreen = Convert.ToBoolean( oINIFile.GetValueForKey( INIFileConstants.m_cFULLSCREEN,"False" ) );

			//Get the resolution
			sResolution = (string)oINIFile.GetValueForKey( INIFileConstants.m_cRESOLUTION,
								INIFileConstants.m_cRES_DEFAULT_WIDTH.ToString() + "x" + 
								INIFileConstants.m_cRES_DEFAULT_HEIGHT.ToString() );
			saResolution = DSMisc.Split( sResolution,"x" );
			if( DSMisc.IsNumericLong( saResolution[ 0 ] ) == false || 
				DSMisc.IsNumericLong( saResolution[ 1 ] ) == false )
			{
				bUseDefaultRes = true;
			}
			else
			{
				nWidth = Convert.ToInt32( saResolution[ 0 ] );
				nHeight = Convert.ToInt32( saResolution[ 1 ] );

				if( Math.Abs( 1.3 - ( (double)nWidth / (double)nHeight ) ) > .1 )
				{
					bUseDefaultRes = true;
				}
			}

			if( m_oGameEngine.FullScreen == true )
			{
				if( bUseDefaultRes == true )
				{
					m_oGameEngine.FullScreenResolution = new Vector2( INIFileConstants.m_cRES_DEFAULT_WIDTH,INIFileConstants.m_cRES_DEFAULT_HEIGHT );
				}
				else
				{
					m_oGameEngine.FullScreenResolution = new Vector2( nWidth,nHeight );
				}
			}
			else
			{
				if( bUseDefaultRes == true )
				{
					this.Width = (int)INIFileConstants.m_cRES_DEFAULT_WIDTH - ( this.ClientSize.Width - this.Width );
					this.Height = (int)INIFileConstants.m_cRES_DEFAULT_HEIGHT - ( this.ClientSize.Height - this.Height );
				}
				else
				{
					this.Width = (int)nWidth - ( this.ClientSize.Width - this.Width );
					this.Height = (int)nHeight - ( this.ClientSize.Height - this.Height );
				}
			}
		}
		private void RestoreDeviceVertexBuffers()
		{
			//Globals.Inst().RestoreDeviceVertexBuffers( m_oGameEngine );
			/*Globals.QuadVertex[] oVerts = null;


			//DSResourceManager.GetGlobalInstance().CreateVertexBuffer(
			m_oVertexBuffer = new Microsoft.DirectX.Direct3D.VertexBuffer(
				typeof(Globals.QuadVertex), 
				4, m_oGameEngine.Direct3DDevice, 0, 
				( VertexFormats.Position | VertexFormats.Texture1 | VertexFormats.Texture2 ), 
				Microsoft.DirectX.Direct3D.Pool.Default);

			oVerts = (Globals.QuadVertex[])m_oVertexBuffer.Lock(0,0);

			Globals.Inst().m_oVertexBuffer = m_oVertexBuffer;
			Globals.Inst().oVerts = oVerts;

			oVerts[0].X=-1.0f; oVerts[0].Y=-1.0f; oVerts[0].Z=0.0f;  oVerts[0].Tu1 = 0.0f; oVerts[0].Tv1=0.0f;  oVerts[0].Tu2 = 0.0f; oVerts[0].Tv2=0.0f;
			oVerts[1].X=-1.0f; oVerts[1].Y=1.0f ; oVerts[1].Z=0.0f;  oVerts[1].Tu1 = 1.0f; oVerts[1].Tv1=0.0f;  oVerts[1].Tu2 = 1.0f; oVerts[1].Tv2=0.0f;
			oVerts[2].X=1.0f;  oVerts[2].Y=-1.0f; oVerts[2].Z=0.0f;  oVerts[2].Tu1 = 0.0f; oVerts[2].Tv1=1.0f;  oVerts[2].Tu2 = 0.0f; oVerts[2].Tv2=1.0f;
			oVerts[3].X=1.0f;  oVerts[3].Y=1.0f;  oVerts[3].Z=0.0f;  oVerts[3].Tu1 = 1.0f; oVerts[3].Tv1=1.0f;  oVerts[3].Tu2 = 1.0f; oVerts[3].Tv2=1.0f;

			m_oVertexBuffer.Unlock();*/
		}
		public void SetRenderStates(object sender, System.EventArgs e)
		{
			//m_oGameEngine.MouseInExclusiveMode = true;

			//Create our vertex buffers 
			RestoreDeviceVertexBuffers();

			//Some basic render states
			//09/08/2007 Chris Hill  Un-needed and causing a problem.
			//m_oGameEngine.Direct3DDevice.RenderState.ZBufferEnable = true;
			//m_oGameEngine.Direct3DDevice.RenderState.DitherEnable = true;
			//m_oGameEngine.Direct3DDevice.RenderState.SpecularEnable = true;
			m_oGameEngine.Direct3DDevice.RenderState.Lighting = false;

			// Restore the states
			m_oGameEngine.Direct3DDevice.TextureState[0].ColorArgument1 = TextureArgument.TextureColor;
			m_oGameEngine.Direct3DDevice.TextureState[0].ColorArgument2 = TextureArgument.Diffuse;
			m_oGameEngine.Direct3DDevice.TextureState[0].ColorOperation = TextureOperation.Modulate;
			m_oGameEngine.Direct3DDevice.SamplerState[0].MinFilter = TextureFilter.Linear;
			m_oGameEngine.Direct3DDevice.SamplerState[0].MagFilter = TextureFilter.Linear;
		}

		private void StellarLanes_Resize(object sender, System.EventArgs e)
		{
			DSForm oLoopForm = null;


			for( int i=0 ; i<m_oGameEngine.Forms.Count ; i++ )
			{
				oLoopForm = (DSForm)m_oGameEngine.Forms.GetForm( i );

				//Go through all our forms and center them
				if( oLoopForm.Visible == true && oLoopForm.Name != MenuConstants.m_cMENU_MAIN )
				{					
					CenterWindow( oLoopForm );
				}				
			}

			ChatLobbyResize();
		}
		private void MakeSureWindowIsOnScreen( DSForm oForm )
		{
			int nTemp = 0;


			if( oForm.Left < 0 )
			{
				oForm.Left = 0;
			}
			if( oForm.Top < 0 )
			{
				oForm.Top = 0;
			}

			if( oForm.Right > m_oGameEngine.ScreenWidth )
			{
				nTemp = oForm.Right - m_oGameEngine.ScreenWidth;
				if( oForm.Left - nTemp < 0 )
				{
					oForm.Left = 0;
					oForm.Size = new Vector2( m_oGameEngine.ScreenWidth,oForm.Size.Y );
				}
				else
				{
					oForm.Left -= nTemp;
				}
			}
			if( oForm.Bottom > m_oGameEngine.ScreenHeight )
			{
				nTemp = oForm.Bottom - m_oGameEngine.ScreenHeight;
				if( oForm.Top - nTemp < 0 )
				{
					oForm.Top = 0;
					oForm.Size = new Vector2( oForm.Size.X,m_oGameEngine.ScreenHeight );
				}
				else
				{
					oForm.Top -= nTemp;
				}
			}
		}
		private void CenterWindow( DSForm oForm )
		{
			oForm.Left = (int)( m_oGameEngine.ScreenWidth / 2.0 - oForm.Size.X / 2.0 );
			oForm.Top = (int)( m_oGameEngine.ScreenHeight / 2.0 - oForm.Size.Y / 2.0 );
		}

		private void Advance(object sender, System.EventArgs e)
		{
			TimeSpan oSpan = TimeSpan.MinValue;
			DSGobFile oGobFile = null;
			double nElapsedTime = ((DSGameEngineArgs)e).ElapsedTime;
            string sFileName = string.Empty;


			try
			{
				m_nTimeSinceLastSwag += nElapsedTime;


				if( m_oStarscape != null &&
					( m_nGameState == enumStates.MainMenu || m_nGameState == enumStates.FadingInMainMenu ) )
				{
					m_oStarscape.AdvanceStarScape( 1,
							new Vector2( (float)( Math.Cos( m_nStarMotionAngle ) * -nElapsedTime*m_nStarMotionMagnitude ),
										 (float)( Math.Sin( m_nStarMotionAngle ) * -nElapsedTime*m_nStarMotionMagnitude ) ) );
				}

				//First of all, are we doing anything?
				if( m_nGameState == enumStates.LoadingApp )
				{
					oGobFile = new DSGobFile();

                    if( System.Diagnostics.Debugger.IsAttached == true )
                    {
                        sFileName = DSMisc.GetDevelopmentAppPath() + @"..\DSIntro.gob";
                    }
                    else
                    {
                        sFileName = DSMisc.GetDevelopmentAppPath() + @"DSIntro.gob";
                    }
                    if (System.IO.File.Exists(sFileName) == false)
                    {
                        MessageBox.Show("The file <" + sFileName + "> does not exist.  This file is required to play the game.", "Load Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
                        this.Close();
                    }
                    else
                    {
                        oGobFile.LoadGobFile(sFileName);
                    }

					m_nGameState = enumStates.SplashScreen;
					m_oDSIntro = new DarkStrideIntro( m_oGameEngine );

					//Start the loading thread
					m_oLoadingThread = new Thread( new ThreadStart( this.LoadingGOBThread ) );
					m_oLoadingThread.Priority = System.Threading.ThreadPriority.BelowNormal;
					m_oLoadingThread.IsBackground = true;
					m_oLoadingThread.Start();
				}
				else if( m_nGameState == enumStates.SplashScreen )
				{
					m_oDSIntro.Advance( nElapsedTime );

					if( m_oDSIntro.DoneWithIntro == true )
					{
						m_oDSIntro = null;
						if( m_nGobLoadingProgress < 1 )
						{
							m_nGameState = enumStates.LoadingGobs;
						}
						else
						{
							//Launch the menu!
							m_nFadeAmount = 0;
							m_nGameState = enumStates.FadingInMainMenu;
							StartMainForm( false );
						}					
					}
				}
				else if( m_nGameState == enumStates.LoadingGobs )
				{
					if( m_nGobLoadingProgress >= 1 )
					{
						m_nGameState = enumStates.FadingLoadingScreen;
					}
				}
				else if( m_nGameState == enumStates.FadingLoadingScreen )
				{
					m_nFadeAmount -= nElapsedTime / 2;

					if( m_nFadeAmount <= 0 )
					{
						//Launch the menu!
						m_nFadeAmount = 0;
						m_nGameState = enumStates.FadingInMainMenu;
						StartMainForm( false );
					}
				}
				else if( m_nGameState == enumStates.FadingInMainMenu )
				{
					m_nFadeAmount += nElapsedTime;

					if( m_nFadeAmount >= 1 )
					{
						m_nGameState = enumStates.MainMenu;
					}
				}
				else if( m_nGameState == enumStates.InGame )
				{
					//See if we should send the host our ship again
					m_oSession.Advance( nElapsedTime );
				}
			}
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( oEx );
			} 
		}
		private void RenderBeforeForms(object sender, System.EventArgs e)
		{
			TimeSpan oSpan = TimeSpan.MinValue;
			System.Drawing.Rectangle oTargetRect = System.Drawing.Rectangle.Empty;
			Microsoft.DirectX.Direct3D.Font oFont = null;
			int nTemp = 0;


			oFont = DSResourceManager.GetGlobalInstance().GetFont( GraphicConstants.m_cSLFONT );
			if( m_nGameState == enumStates.MainMenu || m_nGameState == enumStates.FadingInMainMenu )
			{
				if( m_oStarscape == null )
				{
					m_oStarscape = new Starscape( m_oGameEngine );
					m_nStarMotionAngle = DSMisc.GetRnd() * Math.PI * 2;
					m_nStarMotionMagnitude = DSMisc.GetRnd( 30,45 );
				}
				m_oStarscape.RenderStarScape();

				//Render "Stellar Lanes" on the screen.
				oTargetRect = new System.Drawing.Rectangle( 
					(int)( m_oGameEngine.ScreenWidth * .10 ),(int)( m_oGameEngine.ScreenHeight * .10 ),
					(int)( m_oGameEngine.ScreenWidth * .80 ),(int)( m_oGameEngine.ScreenHeight * .20 ) );
				m_oGameEngine.RenderTexture2D(GraphicConstants.m_cMENU_TITLE,
					System.Drawing.Rectangle.Empty,oTargetRect,Vector2.Empty,0,0,false,
					System.Drawing.Color.White.ToArgb() );
			}

			if( m_nGameState == enumStates.SplashScreen )
			{
				m_oDSIntro.Render2DAfterForms();
			}
			else if( m_nGameState == enumStates.LoadingGobs || m_nGameState == enumStates.FadingLoadingScreen )
			{
				//Tell them we are loading
				nTemp = (int)( m_nGobLoadingProgress * 100 );

				oSpan = DateTime.Now - m_dtLoadingScreenPeriodStartTime;
				if( oSpan.TotalSeconds > 6 )
				{
					m_dtLoadingScreenPeriodStartTime = DateTime.Now;
				}
				oFont.DrawText(	null, "Loading" + DSMisc.Repeat( ".",(int)oSpan.TotalSeconds ), 
					new System.Drawing.Rectangle( 40,m_oGameEngine.ScreenHeight - 50,0,0 ), 
					DrawTextFormat.NoClip,
					System.Drawing.Color.FromArgb( 71,94,116 ).ToArgb() );
				oFont.DrawText(	null, nTemp.ToString() + "%", 
					new System.Drawing.Rectangle( 150,m_oGameEngine.ScreenHeight - 50,0,0 ), 
					DrawTextFormat.NoClip,
					System.Drawing.Color.FromArgb( 71,94,116 ).ToArgb() );
				//m_oGameEngine.RenderText( 20,200,System.Drawing.Color.White,"Loading... " + nTemp.ToString() + "%" );
			}
			else if( m_nGameState == enumStates.InGame )
			{
				m_oSession.Render2DAfterForms();
			}
			else if( m_nGameState == enumStates.MainMenu )
			{
				oFont.DrawText(	null, "v" + Application.ProductVersion, 
					new System.Drawing.Rectangle( m_oGameEngine.ScreenWidth - 110,m_oGameEngine.ScreenHeight - 20,0,0 ), 
					DrawTextFormat.NoClip,
					System.Drawing.Color.FromArgb( 71,94,116 ).ToArgb() );
			}


			if( m_nGameState == enumStates.FadingLoadingScreen || m_nGameState == enumStates.FadingInMainMenu )
			{
				//Display the fade
				m_oGameEngine.RenderRect2D( 
					new Rectangle( 0,0,m_oGameEngine.ScreenWidth,m_oGameEngine.ScreenHeight ),
					System.Drawing.Color.Black.ToArgb(),m_nFadeAmount );
			}
		}
		private void LoadINIFile()
		{
			DSINIFile oINIFile = null;


			oINIFile = new DSINIFile();
			oINIFile.OpenINIFile( DSMisc.GetDevelopmentAppPath() + INIFileConstants.m_cINIFILENAME,false );

			m_bFullscreen = Convert.ToBoolean( oINIFile.GetValueForKey( INIFileConstants.m_cFULLSCREEN,"False" ) );
            m_bFullscreenSettingToSave = m_bFullscreen;
			m_sResolution = (string)oINIFile.GetValueForKey( INIFileConstants.m_cRESOLUTION,
										INIFileConstants.m_cRES_DEFAULT_WIDTH.ToString() + "x" + 
										INIFileConstants.m_cRES_DEFAULT_HEIGHT.ToString() );
			m_nVolume = Convert.ToInt32( oINIFile.GetValueForKey( INIFileConstants.m_cVOLUME,"93" ) );
			m_bMuted = Convert.ToBoolean( oINIFile.GetValueForKey( INIFileConstants.m_cMUTED,"False" ) );
			m_sLastUsedIP = oINIFile.GetValueForKey( INIFileConstants.m_cLASTIPUSED,"" );
		}
		private void SaveINIFile()
		{
			DSINIFile oINIFile = null;


			oINIFile = new DSINIFile();
			oINIFile.OpenINIFile( DSMisc.GetDevelopmentAppPath() + INIFileConstants.m_cINIFILENAME,false );

            oINIFile.AddKey(INIFileConstants.m_cFULLSCREEN, m_bFullscreenSettingToSave.ToString());
			oINIFile.AddKey( INIFileConstants.m_cRESOLUTION,m_sResolution );
			oINIFile.AddKey( INIFileConstants.m_cVOLUME,m_nVolume.ToString() );
			oINIFile.AddKey( INIFileConstants.m_cMUTED,m_bMuted.ToString() );
			oINIFile.AddKey( INIFileConstants.m_cLASTIPUSED,m_sLastUsedIP );

			oINIFile.SaveINIFile();
		}
		private void SetupSound()
		{
			m_oGameEngine.DirectSound.Muted = m_bMuted;
			m_oGameEngine.DirectSound.Volume = (double)m_nVolume / 100.0;
		}
		private void SetupVideo()
		{
			string[] saResolution = null;
			long nWidth = 0;
			long nHeight = 0;


			//Get the resolution
			saResolution = DSMisc.Split( m_sResolution,"x" );

			if( DSMisc.IsNumericLong( saResolution[ 0 ] ) == false || 
				DSMisc.IsNumericLong( saResolution[ 1 ] ) == false )
			{
				nWidth = INIFileConstants.m_cRES_DEFAULT_WIDTH;
				nHeight = INIFileConstants.m_cRES_DEFAULT_HEIGHT;
			}
			else
			{
				nWidth = Convert.ToInt32( saResolution[ 0 ] );
				nHeight = Convert.ToInt32( saResolution[ 1 ] );

				if( Math.Abs( 1.3 - ( (double)nWidth / (double)nHeight ) ) > .1 )
				{
					nWidth = INIFileConstants.m_cRES_DEFAULT_WIDTH;
					nHeight = INIFileConstants.m_cRES_DEFAULT_HEIGHT;
				}
			}

			if( m_bFullscreen == true )
			{
				m_oGameEngine.FullScreenResolution = new Vector2( nWidth,nHeight );
			}
			else
			{
				this.Width = (int)nWidth - ( this.ClientSize.Width - this.Width );
				this.Height = (int)nHeight - ( this.ClientSize.Height - this.Height );
			}


			//Fullscreen or not?
			m_oGameEngine.FullScreen = m_bFullscreen;
		}
		#endregion
        #region Menu Functions
		private void InitMenuEvents()
		{
			StartMainForm( true );
			StartSelectProfile( true );
			StartNewProfile( true );
			StartWaitingToConnect( true );
			StartChatLobby( true );
			StartOptions( true );
			StartResumeGame( true );
			StartSelectIP( true );
		}
		private void SwitchMenus( string sCurrentMenuName,string sNewMenuName )
		{
			DSForm oForm = null;

			if( sCurrentMenuName.Length > 0 )
			{
				oForm = m_oGameEngine.Forms.GetForm( sCurrentMenuName );
				oForm.Visible = false;
			}

			if( sNewMenuName.Length > 0 )
			{
				oForm = m_oGameEngine.Forms.GetForm( sNewMenuName );
				oForm.Visible = true;
			}
		}
        
		private void StartMainForm( bool bInitEvents )
		{
			DSForm oForm = null;
			DSButton oButton = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_MAIN );

			if( bInitEvents == true )
			{
				oButton = (DSButton)oForm.GetControl( "cmdExit" );
				oButton.Click += new EventHandler( cmdExit_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdConnect" );
				/*oButton.Click += new EventHandler( cmdConnect_Click );
				oButton.Click += new EventHandler( cmdAll_Click );				
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );*/
                oButton.Label = "Offline";
                oButton.Enabled = false; 

				oButton = (DSButton)oForm.GetControl( "cmdOptions" );
				oButton.Click += new EventHandler( cmdOptions_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdJoinGame" );
				oButton.Click += new EventHandler( cmdJoinGame_Click );
				oButton.Click += new EventHandler( cmdAll_Click );				
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );	
			}
			else
			{
				if( oForm.Visible == false )
				{
					oForm.Visible = true;
					oForm.Top += (int)( m_oGameEngine.ScreenHeight * .10 );
				}
			}
		}
		private void cmdOptions_Click( object sender, EventArgs e )
		{
			m_bStartedOptionsFromInGameResumeMenu = false;
			StartOptions( false );
			SwitchMenus( MenuConstants.m_cMENU_MAIN,MenuConstants.m_cMENU_OPTIONS );
		}
		private void cmdConnect_Click( object sender, EventArgs e )
		{
			StartSelectProfile( false );
			m_bStartedProfileSelectFromConnectMenu = true;
			SwitchMenus( MenuConstants.m_cMENU_MAIN,MenuConstants.m_cMENU_SELPROFILE );
		}
		private void cmdExit_Click( object sender, EventArgs e )
		{
			this.Close();
		}
		private void cmdJoinGame_Click( object sender, EventArgs e )
		{
			StartSelectProfile( false );
			m_bStartedProfileSelectFromConnectMenu = false;
			SwitchMenus( MenuConstants.m_cMENU_MAIN,MenuConstants.m_cMENU_SELPROFILE );
		}
				
		private void StartSelectIP( bool bInitEvents )
		{
			DSForm oForm = null;
			DSButton oButton = null;
			DSEditBox oTextBox = null;
			string sLastUsedIP = string.Empty;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_ENTERIP );

			if( bInitEvents == true )
			{
				oButton = (DSButton)oForm.GetControl( "cmdCancel" );
				oButton.Click += new EventHandler( cmdEnterIPCancel_Click );
				oButton.Click += new EventHandler( cmdAll_Click );				
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdConnect" );
				oButton.Click += new EventHandler( cmdEnterIPConnect_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );
				oButton.Enabled = false;

				oTextBox = (DSEditBox)oForm.GetControl( "txtIP" );
				oTextBox.Changed += new EventHandler( txtIP_Changed );
				oTextBox.KeyDown += new EventHandler( txtAll_KeyDown );
				oTextBox.MouseEnter += new EventHandler( cmdAll_MouseEnter );
				oTextBox.Text = m_sLastUsedIP;
			}
			else
			{
				oTextBox = (DSEditBox)oForm.GetControl( "txtIP" );
				oTextBox.Text = m_sLastUsedIP;

                oButton = (DSButton)oForm.GetControl("cmdConnect");
                oButton.Enabled = (oTextBox.Text.Length > 0);
			}
		}
		private void cmdEnterIPConnect_Click( object sender, EventArgs e )
		{
			string sIP = string.Empty;
			int nPort = 0;
			DSForm oForm = null;
			DSButton oButton = null;
			DSEditBox oTextBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_ENTERIP );
			oTextBox = (DSEditBox)oForm.GetControl( "txtIP" );
			oButton = (DSButton)oForm.GetControl( "cmdConnect" );

			m_sLastUsedIP = oTextBox.Text;

			SwitchMenus( MenuConstants.m_cMENU_ENTERIP,"" );
			GetServerIP( ref sIP,ref nPort );
			ConnectToServer( m_sLastUsedIP,nPort );
		}
		private void txtIP_Changed( object sender, EventArgs e )
		{
			DSForm oForm = null;
			DSButton oButton = null;
			DSEditBox oTextBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_ENTERIP );
			oTextBox = (DSEditBox)oForm.GetControl( "txtIP" );
			oButton = (DSButton)oForm.GetControl( "cmdConnect" );

			oButton.Enabled = ( oTextBox.Text.Length > 0 );
		}
		private void cmdEnterIPCancel_Click( object sender, EventArgs e )
		{
			StartMainForm( false );
			SwitchMenus( MenuConstants.m_cMENU_ENTERIP,MenuConstants.m_cMENU_MAIN );
		}

		private void StartOptions( bool bInitEvents )
		{
			DSCheckBox oCheckBox = null;
			DSSlider oSlider = null;
			DSForm oForm = null;
			DSButton oButton = null;
			DSComboBox oComboBox = null;
            DSLabel oLabel = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_OPTIONS );

			if( bInitEvents == true )
			{
				oSlider = (DSSlider)oForm.GetControl( "sldVolume" );
				oSlider.ValueChanged += new EventHandler( sldSlider_ValueChanged );

				oCheckBox = (DSCheckBox)oForm.GetControl( "chkMute" );
				oCheckBox.Changed += new EventHandler( cmdAll_MouseEnter );
				oCheckBox.Changed += new EventHandler( chkOptionsMute_Checked );

				oComboBox = (DSComboBox)oForm.GetControl( "cmbResolution" );
				oComboBox.Changed += new EventHandler( cmdAll_MouseEnter );
				oComboBox.Changed += new EventHandler( cmbResolution_Change );
				oComboBox.AddItem( "1024 x 768","1024x768" );
				oComboBox.AddItem( "800 x 600","800x600" );
				oComboBox.AddItem( "640 x 480","640x480" );

				oCheckBox = (DSCheckBox)oForm.GetControl( "chkFullScreen" );
				oCheckBox.Changed += new EventHandler( cmdAll_MouseEnter );
				oCheckBox.Changed += new EventHandler( chkOptionsFullscreen_Checked );

				oButton = (DSButton)oForm.GetControl( "cmdSave" );
				oButton.Click += new EventHandler( cmdOptionsApply_Click );
				oButton.Click += new EventHandler( cmdAll_Click );				
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdCancel" );
				oButton.Click += new EventHandler( cmdOptionsCancel_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );
			}
			else
			{
                oCheckBox = (DSCheckBox)oForm.GetControl("chkFullScreen");
                oCheckBox.IsChecked = (m_bFullscreenSettingToSave == true);

				oCheckBox = (DSCheckBox)oForm.GetControl( "chkMute" );
				oCheckBox.IsChecked = ( m_oGameEngine.DirectSound.Muted == true );

				oComboBox = (DSComboBox)oForm.GetControl( "cmbResolution" );
				oComboBox.SetSelectedByData( m_sResolution );

				oSlider = (DSSlider)oForm.GetControl( "sldVolume" );
				oSlider.Value = 0;
				oSlider.SetRange( 80,100 );
				oSlider.Value = m_nVolume;

                oLabel = (DSLabel)oForm.GetControl("lblVolumeNumber");
                oLabel.Label = INIVolToPercent(m_nVolume).ToString() + "%";
			}
		}
		private void cmbResolution_Change( object sender, EventArgs e )
		{
			DSForm oForm = null;
			DSComboBox oComboBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_OPTIONS );

			oComboBox = (DSComboBox)oForm.GetControl( "cmbResolution" );
			m_sResolution = (string)oComboBox.GetSelectedData();
		}
		private void cmdOptionsCancel_Click( object sender, EventArgs e )
		{
			LoadINIFile();
			SetupSound();

			if( m_bStartedOptionsFromInGameResumeMenu == false )
			{
				SwitchMenus( MenuConstants.m_cMENU_OPTIONS,MenuConstants.m_cMENU_MAIN );
				StartMainForm( false );
			}
			else
			{  
				SwitchMenus( MenuConstants.m_cMENU_OPTIONS,MenuConstants.m_cMENU_RESUME );
			}
		}
		private void cmdOptionsApply_Click( object sender, EventArgs e )
		{
			SaveINIFile();
			SetupVideo();

			if( m_bStartedOptionsFromInGameResumeMenu == false )
			{
				SwitchMenus( MenuConstants.m_cMENU_OPTIONS,MenuConstants.m_cMENU_MAIN );
                StartMainForm(false);
			}
			else
			{
				SwitchMenus( MenuConstants.m_cMENU_OPTIONS,MenuConstants.m_cMENU_RESUME );
			}
		}		
		private void chkOptionsMute_Checked( object sender, EventArgs e )
		{
			DSCheckBox oCheckBox = null;
			DSLabel oLabel = null;
			TimeSpan oSpan = TimeSpan.MinValue;
			DSSlider oSlider = null;
			DSForm oForm = null;


			oSpan = DateTime.Now - m_dtTimeSinceLastVolumeChangeClick;
			if( oSpan.TotalSeconds > .1 )
			{
				m_dtTimeSinceLastVolumeChangeClick = DateTime.Now;

				oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_OPTIONS );

				oCheckBox = (DSCheckBox)oForm.GetControl( "chkMute" );
				m_bMuted = oCheckBox.IsChecked;
				m_oGameEngine.DirectSound.Muted = m_bMuted;

				oLabel = (DSLabel)oForm.GetControl( "lblVolumeNumber" );
				oLabel.Enabled = ( m_bMuted == false );

				oSlider = (DSSlider)oForm.GetControl( "sldVolume" );
				oSlider.Enabled = ( m_bMuted == false );

				cmdAll_MouseEnter( null,null );
			}
		}
		private void chkOptionsFullscreen_Checked( object sender, EventArgs e )
		{
			DSCheckBox oCheckBox = null;
			DSForm oForm = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_OPTIONS );

			oCheckBox = (DSCheckBox)oForm.GetControl( "chkFullScreen" );
            m_bFullscreenSettingToSave = oCheckBox.IsChecked;

			cmdAll_MouseEnter( null,null );
		}
		private void sldSlider_ValueChanged( object sender, EventArgs e )
		{
			DSLabel oLabel = null;
			TimeSpan oSpan = TimeSpan.MinValue;
			DSSlider oSlider = null;
			DSForm oForm = null;


            oForm = m_oGameEngine.Forms.GetForm(MenuConstants.m_cMENU_OPTIONS);

            oSlider = (DSSlider)oForm.GetControl("sldVolume");
            m_oGameEngine.DirectSound.Volume = (double)oSlider.Value / 100.0;

            oLabel = (DSLabel)oForm.GetControl("lblVolumeNumber");
            m_nVolume = oSlider.Value;
            oLabel.Label = INIVolToPercent( m_nVolume ).ToString() + "%";

			oSpan = DateTime.Now - m_dtTimeSinceLastVolumeChangeClick;
			if( oSpan.TotalSeconds > .1 )
			{
				m_dtTimeSinceLastVolumeChangeClick = DateTime.Now;
				cmdAll_MouseEnter( null,null );
			}
		}
        private int INIVolToPercent(int nINIVol)
        {
            int nSliderVol = 0;
            double nPerc = 0;

            nPerc = ((double)nINIVol - 80.0) / 20.0;
            nSliderVol = (int)(nPerc * 100.0);

            return (nSliderVol);
        }
		
		private void StartResumeGame( bool bInitEvents )
		{
			//DSCheckBox oCheckBox = null;
			//DSSlider oSlider = null;
			DSForm oForm = null;
			DSButton oButton = null;
			//DSComboBox oComboBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_RESUME );

			if( bInitEvents == true )
			{
				oButton = (DSButton)oForm.GetControl( "cmdExitToMenu" );
				oButton.Click += new EventHandler( cmdExitToMenu_Click );
				oButton.Click += new EventHandler( cmdAll_Click );				
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdOptionsInGame" );
				oButton.Click += new EventHandler( cmdOptionsInGame_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdExitGame" );
				oButton.Click += new EventHandler( cmdExitGameFromResumeMenu_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdResumeGame" );
				oButton.Click += new EventHandler( cmdResumeGame_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );
			}
			else
			{
			}
		}
		private void cmdExitToMenu_Click( object sender, EventArgs e )
		{
			if( m_oGameEngine.DirectPlay.Connected == true )
			{
				m_oGameEngine.DirectPlay.QuitGame();
			}

			m_nGameState = enumStates.MainMenu;
			StartMainForm( false );
			SwitchMenus( MenuConstants.m_cMENU_RESUME,MenuConstants.m_cMENU_MAIN );
		}
		private void cmdOptionsInGame_Click( object sender, EventArgs e )
		{
			m_bStartedOptionsFromInGameResumeMenu = true;
			StartOptions( false );
			SwitchMenus( MenuConstants.m_cMENU_RESUME,MenuConstants.m_cMENU_OPTIONS );
		}
		private void cmdResumeGame_Click( object sender, EventArgs e )
		{
			SwitchMenus( MenuConstants.m_cMENU_RESUME,"" );
		}
		private void cmdExitGameFromResumeMenu_Click( object sender, EventArgs e )
		{
			cmdExit_Click( null,null );
		}
        
		private void StartSelectProfile( bool bInitEvents )
		{
			DSForm oForm = null;
			DSButton oButton = null;
			DSListBox oListBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_SELPROFILE );

			if( bInitEvents == true )
			{
				oListBox = (DSListBox)oForm.GetControl( "lstProfiles" );
				oListBox.Selection += new EventHandler( SelProfileLstProfiles_Selection );
				oListBox.Selection += new EventHandler( cmdAll_Click );				
				oListBox.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdCreateNew" );
				oButton.Click += new EventHandler( CreateNewProfile_Click );
				oButton.Click += new EventHandler( cmdAll_Click );				
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdSelect" );
				oButton.Click += new EventHandler( cmdSelectProfile_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );
				oButton.Enabled = false;

				oButton = (DSButton)oForm.GetControl( "cmdCancel" );
				oButton.Click += new EventHandler( cmdCancelProfile_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );
			}
			else
			{
				ListProfiles();
			
				oButton = (DSButton)oForm.GetControl( "cmdSelect" );
				oButton.Enabled = false;
			}
		}
		private void ListProfiles()
		{
			string[] saFiles = null;
			DSForm oForm = null;
			DSButton oButton = null;
			DSListBox oListBox = null;
			Profile oTempProfile = null;
			bool bErrorInProfile = false;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_SELPROFILE );

			//Fill it with our profiles!
			oListBox = (DSListBox)oForm.GetControl( "lstProfiles" );
			oListBox.Clear();
			saFiles = System.IO.Directory.GetFiles( DSMisc.GetDevelopmentAppPath(),"*.dat" );
			foreach( string sFile in saFiles )
			{
				oTempProfile = new Profile();
				try
				{
					oTempProfile.LoadFromFile( sFile );
					bErrorInProfile = false;
				}
				catch( System.Exception )
				{
					bErrorInProfile = true;
				}

				if( oTempProfile.Name.Length > 0 && bErrorInProfile == false )
				{
					oListBox.AddItem( oTempProfile.Name,oTempProfile );
				}
			}
		
			oButton = (DSButton)oForm.GetControl( "cmdSelect" );
			oButton.Enabled = false;
		}
		private void CreateNewProfile_Click( object sender, EventArgs e )
		{
			StartNewProfile( false );
			SwitchMenus( "",MenuConstants.m_cMENU_NEWPROFILE );
		}
		private void cmdSelectProfile_Click( object sender, EventArgs e )
		{
			string sIP = string.Empty;
			int nPort = 0;
			DSForm oForm = null;
			DSListBox oListBox = null;
			ListBoxItem oItem;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_SELPROFILE );
			
			oListBox = (DSListBox)oForm.GetControl( "lstProfiles" );
			oItem = oListBox.GetSelectedItem();
			m_oProfile = (Profile)oItem.ItemData;
		
			if( m_bStartedProfileSelectFromConnectMenu == true )
			{
				GetServerIP( ref sIP,ref nPort );
				ConnectToServer( sIP,nPort );
			}
			else
			{
				StartSelectIP( false );
				SwitchMenus( MenuConstants.m_cMENU_SELPROFILE,MenuConstants.m_cMENU_ENTERIP );
			}
		}	
		private void cmdCancelProfile_Click( object sender, EventArgs e )
		{
			SwitchMenus( MenuConstants.m_cMENU_SELPROFILE,MenuConstants.m_cMENU_MAIN );
		}	
		private void SelProfileLstProfiles_Selection( object sender, EventArgs e )
		{
			DSForm oForm = null;
			DSButton oButton = null;
			DSListBox oListBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_SELPROFILE );
			
			oListBox = (DSListBox)oForm.GetControl( "lstProfiles" );

			oButton = (DSButton)oForm.GetControl( "cmdSelect" );
			oButton.Enabled = ( oListBox.GetSelectedIndex() != -1 );
		}		
        
		private void StartNewProfile( bool bInitEvents )
		{
			DSForm oForm = null;
			DSButton oButton = null;
			DSEditBox oTextBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_NEWPROFILE );
			oForm.IsModal = true;

			if( bInitEvents == true )
			{
				oTextBox = (DSEditBox)oForm.GetControl( "txtProfileName" );
				oTextBox.Changed += new EventHandler( txtProfileName_Changed );
				oTextBox.KeyDown += new EventHandler( txtAll_KeyDown );
				oTextBox.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdCancel" );
				oButton.Click += new EventHandler( cmdCancelNewProfile_Click );
				oButton.Click += new EventHandler( cmdAll_Click );				
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdCreate" );
				oButton.Click += new EventHandler( cmdDoneCreatingProfile_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );
				oButton.Enabled = false;
			}
			else
			{
				oTextBox = (DSEditBox)oForm.GetControl( "txtProfileName" );
				oTextBox.Text = "";

				oButton = (DSButton)oForm.GetControl( "cmdCreate" );
				oButton.Enabled = false;
			}
		}
		private void txtProfileName_Changed( object sender, EventArgs e )
		{
			DSForm oForm = null;
			DSButton oButton = null;
			DSEditBox oTextBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_NEWPROFILE );			

			oTextBox = (DSEditBox)oForm.GetControl( "txtProfileName" );

			oButton = (DSButton)oForm.GetControl( "cmdCreate" );
			oButton.Enabled = ( oTextBox.Text.Length > 0 );
		}
		private void cmdCancelNewProfile_Click( object sender, EventArgs e )
		{
			SwitchMenus( MenuConstants.m_cMENU_NEWPROFILE,"" );
		}
		private void cmdDoneCreatingProfile_Click( object sender, EventArgs e )
		{
			DSForm oForm = null;
			DSEditBox oTextBox = null;
			Profile oNewProfile = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_NEWPROFILE );

			oTextBox = (DSEditBox)oForm.GetControl( "txtProfileName" );

			oNewProfile = new Profile();
			oNewProfile.Name = oTextBox.Text;
			oNewProfile.SaveToFile( true );

			ListProfiles();
			SwitchMenus( MenuConstants.m_cMENU_NEWPROFILE,"" );
		}

		private void StartWaitingToConnect( bool bInitEvents )
		{
			DSForm oForm = null;
			DSLabel oLabel = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_WAITTOCONNECT );
			oForm.IsModal = false;

			if( bInitEvents == true )
			{
			}
			else
			{
				oLabel = (DSLabel)oForm.GetControl( "lblMessage" );
				oLabel.Label = "CONNECTING";
			}
		}

		private void StartChatLobby( bool bInitEvents )
		{
			DSForm oForm = null;
			DSLabel oLabel = null;
			DSButton oButton = null;
			DSEditBox oTextBox = null;
			DSListBox oListBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			if( bInitEvents == true )
			{
				oTextBox = (DSEditBox)oForm.GetControl( "txtMessage" );
				oTextBox.Changed += new EventHandler( txtChatLobbyMessage_Changed );
				oTextBox.Enter += new EventHandler( txtMessage_Enter );
				oTextBox.KeyDown += new EventHandler( txtAll_KeyDown );
				oTextBox.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oListBox = (DSListBox)oForm.GetControl( "lstSessions" );
				oListBox.Selection += new EventHandler( LobbySessions_Selection );
				oListBox.Selection += new EventHandler( cmdAll_Click );				
				oListBox.MouseEnter += new EventHandler( cmdAll_MouseEnter );
				oListBox.Visible = false;

				oListBox = (DSListBox)oForm.GetControl( "lstLobbyChat" );
				oListBox.Style = DarkStrideToolbox.ListBoxStyle.NoSelection;
				oListBox.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oListBox = (DSListBox)oForm.GetControl( "lstUsers" );
				oListBox.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdSend" );
				oButton.Click += new EventHandler( cmdSend_Click );
				oButton.Click += new EventHandler( cmdAll_Click );				
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdJoin" );
				oButton.Click += new EventHandler( cmdJoin_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );
				oButton.Enabled = false;
    
				oButton = (DSButton)oForm.GetControl( "cmdPostDownloadRestart" );
				oButton.Click += new EventHandler( cmdPostDownloadRestart_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );

				oButton = (DSButton)oForm.GetControl( "cmdQuit" );
				oButton.Click += new EventHandler( cmdQuit_Click );
				oButton.Click += new EventHandler( cmdAll_Click );
				oButton.MouseEnter += new EventHandler( cmdAll_MouseEnter );
				oButton.Enabled = false;

				HideShowChatRoomFileDownloadingFields( false );

				oButton = (DSButton)oForm.GetControl( "cmdPostDownloadRestart" );
				oButton.Visible = false;

				oLabel = (DSLabel)oForm.GetControl( "lblPostDownloadMessage" );
				oLabel.Visible = false;
			}
			else
			{
				ChatLobbyResize();

				oButton = (DSButton)oForm.GetControl( "cmdSend" );
				oButton.Enabled = false;

				oButton = (DSButton)oForm.GetControl( "cmdJoin" );
				oButton.Enabled = false;
			}
		}
		private void ChatLobbyResize()
		{
			DSForm oForm = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			if( oForm != null )
			{
				oForm.Left = 20;
				oForm.Top = 20;
				oForm.Size = new Vector2( m_oGameEngine.ScreenWidth - 40,m_oGameEngine.ScreenHeight - 40 );
			}
		}
		private void txtMessage_Enter( object sender, EventArgs e )
		{
			cmdSend_Click( null,null );
		}
		private void txtChatLobbyMessage_Changed( object sender, EventArgs e )
		{
			DSForm oForm = null;
			DSButton oButton = null;
			DSEditBox oTextBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );			

			oTextBox = (DSEditBox)oForm.GetControl( "txtMessage" );

			oButton = (DSButton)oForm.GetControl( "cmdSend" );
			oButton.Enabled = ( oTextBox.Text.Length > 0 );
		}
		private void cmdSend_Click( object sender, EventArgs e )
		{
			DSForm oForm = null;
			DSButton oButton = null;
			DSEditBox oTextBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oTextBox = (DSEditBox)oForm.GetControl( "txtMessage" );
			oButton = (DSButton)oForm.GetControl( "cmdSend" );

			NetMsg.Send_LobbyChat( m_oGameEngine.DirectPlay,m_oGameEngine.DirectPlay.Me,m_oGameEngine.DirectPlay.PlayerWhoIsHost,oTextBox.Text );
			AddChatLobbyTextMessage( m_oGameEngine.DirectPlay.Me.Name,oTextBox.Text );//+ " (Ping:" + m_oGameEngine.DirectPlay.PlayerWhoIsHost.LastPingInSeconds.ToString() + ")" );

			oButton.Enabled = false;
			oTextBox.Text = "";
		}
		private void cmdJoin_Click( object sender, EventArgs e )
		{
			DSForm oForm = null;
			DSListBox oListBox = null;
			string sGUID = "";


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oListBox = (DSListBox)oForm.GetControl( "lstSessions" );
			sGUID = (string)oListBox.GetSelectedItem().ItemData;

			NetMsg.Send_JoinSession( m_oGameEngine.DirectPlay,m_oGameEngine.DirectPlay.PlayerWhoIsHost,m_oGameEngine.DirectPlay.Me,sGUID );

			m_nGameState = enumStates.LobbyWaitingForSessionToStart;

			StartWaitingToJoin( false );
			SwitchMenus( "",MenuConstants.m_cMENU_WAITTOCONNECT );
		}
		private void cmdQuit_Click( object sender, EventArgs e )
		{
			m_oGameEngine.DirectPlay.CloseNetwork();

			StartMainForm( false );
			SwitchMenus( MenuConstants.m_cMENU_CHATLOBBY,MenuConstants.m_cMENU_MAIN );
		}
		private void LobbySessions_Selection( object sender, EventArgs e )
		{
			DSForm oForm = null;
			DSButton oButton = null;
			DSListBox oListBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );			

			oListBox = (DSListBox)oForm.GetControl( "lstSessions" );

			oButton = (DSButton)oForm.GetControl( "cmdJoin" );
			oButton.Enabled = ( oListBox.GetSelectedIndex() != -1 );
		}
		private void AddChatLobbyTextMessage( string sPlayerName,string sMessage )
		{
			DSForm oForm = null;
			DSListBox oListBox = null;
			int nIndex = -1;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oListBox = (DSListBox)oForm.GetControl( "lstLobbyChat" );
			nIndex = oListBox.AddItem( sPlayerName + ": " + sMessage,null );
			oListBox.SelectItem( nIndex );

			m_oGameEngine.DirectSound.PlaySound( SoundConstants.m_cNEWMSG );
		}
		private void AddChatLobbySession( string sSessionName,string sGUID )
		{
			DSForm oForm = null;
			DSListBox oListBox = null;


			if( IsSessionInSessionListYet( sGUID ) == false )
			{
				oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

				oListBox = (DSListBox)oForm.GetControl( "lstSessions" );
				oListBox.AddItem( sSessionName,sGUID );
			}
		}
		private bool IsSessionInSessionListYet( string sSessionGUID )
		{
			DSForm oForm = null;
			DSListBox oListBox = null;
			ListBoxItem oItem;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oListBox = (DSListBox)oForm.GetControl( "lstSessions" );

			for( int i=0 ; i<oListBox.NumberItems ; i++ )
			{
				oItem = oListBox.GetByIndex( i );
				if( oItem.ItemData.GetType() == typeof( string ) &&
					(string)oItem.ItemData == sSessionGUID )
				{
					return( true );
				}
			}


			return( false );
		}
		private void DelChatLobbySession( string sGUID )
		{
			DSForm oForm = null;
			DSListBox oListBox = null;
			DarkStrideToolbox.ListBoxItem oItem;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oListBox = (DSListBox)oForm.GetControl( "lstSessions" );
			for( int i=0 ; i<oListBox.GetItemCount() ; i++ )
			{
				oItem = oListBox.GetByIndex( i );
				if( (string)oItem.ItemData == sGUID )
				{
					oListBox.RemoveAt( i );
					break;
				}
			}			
		}
		private void AddChatLobbyUser( DSNetworkPlayer oNewPlayer )
		{
			DSForm oForm = null;
			DSListBox oListBox = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oListBox = (DSListBox)oForm.GetControl( "lstUsers" );

			oListBox.AddItem( oNewPlayer.Name,oNewPlayer );
		}
		private void UpdateChatLobbyUser( int nSocketID,string sSessionGUID )
		{
			DSForm oForm = null;
			DSListBox oListBox = null;
			DarkStrideToolbox.ListBoxItem oItem;
			DSNetworkPlayer oLoopPlayer = null;
			string sSessionName = "";


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			//Get the session they are in
			if( sSessionGUID.Length > 0 )
			{
				sSessionName = " (In Game)";
			}

			oListBox = (DSListBox)oForm.GetControl( "lstUsers" );

			oListBox = (DSListBox)oForm.GetControl( "lstUsers" );
			for( int i=0 ; i<oListBox.GetItemCount() ; i++ )
			{
				oItem = oListBox.GetByIndex( i );
				oLoopPlayer = (DSNetworkPlayer)oItem.ItemData;
				if( oLoopPlayer.SocketID == nSocketID )
				{
					oItem.ItemText = oLoopPlayer.Name + sSessionName;
					break;
				}
			}		
		}
		private void DelChatLobbyUser( DSNetworkPlayer oPlayer )
		{
			DSForm oForm = null;
			DSListBox oListBox = null;
			DarkStrideToolbox.ListBoxItem oItem;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oListBox = (DSListBox)oForm.GetControl( "lstUsers" );
			for( int i=0 ; i<oListBox.GetItemCount() ; i++ )
			{
				oItem = oListBox.GetByIndex( i );
				if( ((DSNetworkPlayer)oItem.ItemData).SocketID == oPlayer.SocketID )
				{
					oListBox.RemoveAt( i );
					break;
				}
			}			
		}

		//Chat lobby file uploading
		private void StartFileDownloading( string[] saFilesNeedingUpdates )
		{
			DSForm oForm = null;
			DSLabel oLabel = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oLabel = (DSLabel)oForm.GetControl( "lblSessionMessage" );
			oLabel.Visible = false;

			FileDownloader_ProgressUpdate( null,null );
			HideShowChatRoomFileDownloadingFields( true );
			ShowContactingFileServerMessage();

			m_oFileDownloader = new FileDownloader();
			m_oFileDownloader.FileTransferProgress += new EventHandler( FileDownloader_ProgressUpdate );
			m_oFileDownloader.FileTransferComplete += new EventHandler( FileDownloader_Complete );
			m_oFileDownloader.DownloadFiles( saFilesNeedingUpdates );
		}
		private void StartFullChatRoomAccess()
		{
			DSForm oForm = null;
			DSListBox oListBox = null;
			DSLabel oLabel = null;


			HideShowChatRoomFileDownloadingFields( false );

			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oLabel = (DSLabel)oForm.GetControl( "lblSessionMessage" );
			oLabel.Visible = true;

			oListBox = (DSListBox)oForm.GetControl( "lstSessions" );
            oListBox.Visible = true;		
		}
		private void HideShowChatRoomFileDownloadingFields( bool bVisible )
		{
			DSForm oForm = null;
			DSLabel oLabel = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			//oLabel = (DSLabel)oForm.GetControl( "lblFileDownloadingMessage" );
			//oLabel.Label = "PATCHING:";

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_CurFileNumber" );
			oLabel.Visible = bVisible;

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_Name" );
			oLabel.Visible = bVisible;

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_FileProgress" );
			oLabel.Visible = bVisible;

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_TotalProgress" );
			oLabel.Visible = bVisible;

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloadingMessage" );
			oLabel.Visible = bVisible;
			
			/*oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_MaxFileNumber" );
			oLabel.Visible = bVisible;*/
		}
		private void ShowContactingFileServerMessage()
		{
			DSForm oForm = null;
			DSLabel oLabel = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_CurFileNumber" );
			oLabel.Label = "Contacting      ";
			oLabel.Visible = true;

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_Name" );
			oLabel.Label = "Patch Server...";
			oLabel.Visible = true;
		}
		private void ShowFileServerUnavailableMessage(System.Exception oError)
		{
			DSForm oForm = null;
			DSLabel oLabel = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_CurFileNumber" );
			oLabel.Label = "Patch Server";
			oLabel.Visible = true;

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_Name" );
			oLabel.Label = "Unavilable";
			oLabel.Visible = true;

MessageBox.Show("Error Patching: " + oError.Message + "\n" + oError.StackTrace);
            m_oGameEngine.WriteToDebug(0, "Failed to download patch: " + oError.Message + "\n" + oError.StackTrace);
		}
		private void FileDownloader_ProgressUpdate( object sender, EventArgs e )
		{
			DSFileDownloadProgresEventArgs oArgs = (DSFileDownloadProgresEventArgs)e;
			DSForm oForm = null;
			DSLabel oLabel = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_Name" );
			if( oArgs != null )
			{
				oLabel.Label = System.IO.Path.GetFileName( oArgs.CurFile );
			}
			else
			{
				oLabel.Label = "";
			}

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_FileProgress" );
			if( oArgs != null )
			{
				oLabel.Label = "File: " + (oArgs.FileProgress*100).ToString( "000" ) + "%";
			}
			else
			{
				oLabel.Label = "";
			}

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_TotalProgress" );
			if( oArgs != null )
			{
				oLabel.Label = "Total: " + (oArgs.TotalProgress*100).ToString( "000" ) + "%";
			}
			else
			{
				oLabel.Label = "";
			}

			oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_CurFileNumber" );
			if( oArgs != null )
			{
				oLabel.Label = "File " + oArgs.FileIndex.ToString() + " of " + oArgs.NumberOfFiles.ToString();
			}
			else
			{
				oLabel.Label = "";
			}

			/*oLabel = (DSLabel)oForm.GetControl( "lblFileDownloading_MaxFileNumber" );
			oLabel.Label = oArgs.NumberOfFiles.ToString();*/
		}
		private void FileDownloader_Complete( object sender, EventArgs e )
		{
			DSFileDownloadCompletedEventArgs oArgs = (DSFileDownloadCompletedEventArgs)e;
			DSForm oForm = null;
			DSLabel oLabel = null;
			DSButton oButton = null;


			HideShowChatRoomFileDownloadingFields( false );
            
			if( oArgs.Successful == true )
			{
				oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_CHATLOBBY );

				oButton = (DSButton)oForm.GetControl( "cmdPostDownloadRestart" );
				oButton.Visible = true;

				oLabel = (DSLabel)oForm.GetControl( "lblPostDownloadMessage" );
				oLabel.Visible = true;
			}
			else
			{
				ShowFileServerUnavailableMessage(oArgs.Error);
			}
		}
		private void cmdPostDownloadRestart_Click( object sender, EventArgs e )
		{
			//Launch recoil!
			m_oFileDownloader.ReplaceExecutables( true );
			m_oFileDownloader = null;

			cmdExit_Click( null,null );
		}

		private void StartWaitingToJoin( bool bInitEvents )
		{
			DSForm oForm = null;
			DSLabel oLabel = null;


			oForm = m_oGameEngine.Forms.GetForm( MenuConstants.m_cMENU_WAITTOCONNECT );
			oForm.IsModal = true;

			if( bInitEvents == true )
			{
			}
			else
			{
				oLabel = (DSLabel)oForm.GetControl( "lblMessage" );
				oLabel.Label = "DOWNLOADING...";

                oLabel = (DSLabel)oForm.GetControl("lblPercent");
                oLabel.Label = "0%";
			}
		}
        private void UpdateWaitingToJoinPerc(double nPerc)
        {
            double nPercTemp = 0;
            DSForm oForm = null;
            DSLabel oLabel = null;

            nPercTemp = nPerc * 100;

            oForm = m_oGameEngine.Forms.GetForm(MenuConstants.m_cMENU_WAITTOCONNECT);
            oForm.IsModal = true;
            
            oLabel = (DSLabel)oForm.GetControl("lblPercent");
            oLabel.Label = nPercTemp.ToString("0") + "%";
        }

		private void cmdAll_Click( object sender, EventArgs e )
		{
			m_oGameEngine.DirectSound.PlaySound( SoundConstants.m_cMENUCLICK );
		}
		private void cmdAll_MouseEnter( object sender, EventArgs e )
		{
			m_oGameEngine.DirectSound.PlaySound( SoundConstants.m_cMENUENTER );
		}		
		private void txtAll_KeyDown( object sender, EventArgs e )
		{
			DSKeyEventArgs oArgs = (DSKeyEventArgs)e;

			if( DSMisc.IsAlphaKey( oArgs.Key ) == true )
			{
				m_oGameEngine.DirectSound.PlaySound( SoundConstants.m_cTYPING );
			}
		}		
		#endregion
		#region Key Functions
		private bool DIMouseMoved( Vector2 vCurPos,MouseState oMouseStateData,bool[] baButtons )
		{
			if( m_nGameState == enumStates.InGame )
			{
				return( m_oSession.DIMouseMoved( vCurPos,oMouseStateData,baButtons ) );
			}
			else
			{
				return( false );
			}
		}
		private bool DIMouseDown( Vector2 vCurPos,long nButton )
		{
			if( m_nGameState == enumStates.InGame )
			{
				return( m_oSession.DIMouseDown( vCurPos,nButton ) );
			}
			else
			{
				return( false );
			}
		}
		private bool DIMouseUp( Vector2 vCurPos,long nButton )
		{
			if( m_nGameState == enumStates.InGame )
			{
				return( m_oSession.DIMouseUp( vCurPos,nButton ) );
			}
			else
			{
				return( false );
			}
		}
		private bool DIKeyboardKeyDown( Key oKey,bool[] oState )
		{
			bool bRetVal = false;


			if( m_nGameState == enumStates.InGame )
			{
				if( oKey == Key.Escape )
				{
					StartResumeGame( false );
					SwitchMenus( "",MenuConstants.m_cMENU_RESUME );
					bRetVal = true;
				}
				else
				{
					bRetVal = m_oSession.DIKeyboardKeyDown( oKey,oState );
				}
			}
			else
			{
				bRetVal = false;
			}

			return( bRetVal );
		}
		private bool DIKeyboardKeyUp( Key oKey,bool[] oState )
		{
			if( m_nGameState == enumStates.InGame )
			{
				return( m_oSession.DIKeyboardKeyUp( oKey,oState ) );
			}
			else
			{
				return( false );
			}
		}


		//This is launched from within the game
		public void LaunchResumeMenu(object sender, System.EventArgs e)
		{
			StartResumeGame( false );
			SwitchMenus( "",MenuConstants.m_cMENU_RESUME );
		}
		#endregion
		#region DirectPlay Functions
		private void DataReceived( DSNetworkPlayer oSendingPlayer,DSNetworkPacket oPacket )
		{
			int n1i = 0;

			try
			{
				m_oGameEngine.WriteToDebug( 1,"Network Message DataReceived: " + oPacket.MsgType.ToString() + ", LEN: " + oPacket.m_nPacketLength.ToString() );

				#region Player maintance messages
				if( oPacket.MsgType == (int)enumNetMsg.PatchAvailabilityResponse )
				{
					string[] saFilesNeedingUpdates = null;
					
					//Do we have any upgrades needed?
					NetMsg.Rcv_PatchAvailabilityResponse( oPacket,ref saFilesNeedingUpdates );

					if( saFilesNeedingUpdates.Length == 0 )
					{
						StartFullChatRoomAccess();
					}
					else if( m_oFileDownloader == null )
					{
						StartFileDownloading( saFilesNeedingUpdates );
					}
				}
					#endregion
				#region Lobby messages
				else if( oPacket.MsgType == (int)enumNetMsg.AddSession )
				{
					string sSessionName = "";
					string sGUID = "";

					NetMsg.Rcv_AddSession( oPacket,ref sSessionName,ref sGUID );
					AddChatLobbySession( sSessionName,sGUID );
				}
				else if( oPacket.MsgType == (int)enumNetMsg.DelSession )
				{
					string sGUID = "";

					NetMsg.Rcv_DelSession( oPacket,ref sGUID );
					DelChatLobbySession( sGUID );
				}
				else if( oPacket.MsgType == (int)enumNetMsg.LobbyChat )
				{ 
					long nSenderSocketID = 0;
					string sMessage = "";
					DSNetworkPlayer oSenderPlayer = null;

					NetMsg.Rcv_LobbyChat( oPacket,ref nSenderSocketID,ref sMessage );

					oSenderPlayer = m_oGameEngine.DirectPlay.GetPlayer( nSenderSocketID );
					if( oSenderPlayer != null )
					{
						AddChatLobbyTextMessage( oSenderPlayer.Name,sMessage );
					}
					else
					{
						AddChatLobbyTextMessage( "Unknown",sMessage );
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.JoinSession )
				{
					int nPlayerJoiningsSocketID = 0;
					string sSessionGUID = "";

					NetMsg.Rcv_JoinSession( oPacket,ref sSessionGUID,ref nPlayerJoiningsSocketID );
					UpdateChatLobbyUser( nPlayerJoiningsSocketID,sSessionGUID );
				}
				else if( oPacket.MsgType == (int)enumNetMsg.QuitSession )
				{
					int nPlayerQuitingsSocketID = 0;
					string sSessionGUID = "";

					NetMsg.Rcv_QuitSession( oPacket,ref sSessionGUID,ref nPlayerQuitingsSocketID );
					UpdateChatLobbyUser( nPlayerQuitingsSocketID,"" );
				}
					#endregion
				#region In game messages
                else if( oPacket.MsgType == (int)enumNetMsg.ZonesUpdate )
                {
                    Zone oZone = null;
                    int nZoneIdx = 0;
                    int nZoneCount = 0;
                    string sZoneSerialized = string.Empty;

                    NetMsg.Rcv_ZonesUpdate(oPacket, ref nZoneIdx,ref nZoneCount,ref sZoneSerialized);

                    Globals.Inst().GameEngine = m_oGameEngine;
                    Globals.Inst().Profile = m_oProfile;
                    if (m_oSession == null)
                    {
                        m_oGameEngine.WriteToDebug(1, "Receiving Zone - Making a new session");
                        m_oSession = new Session();
                        Globals.Inst().Session = m_oSession;
                        Globals.Inst().Session.LaunchResumeMenu += new EventHandler(LaunchResumeMenu);
                    }

                    //Have we processed any zones yet?
                    if (m_oSession.ReceivingZones.Count == 0)
                    {
                        for (int i = 0; i < nZoneCount; i++)
                        {
                            m_oSession.ReceivingZones.Add(null);
                        }
                    }

                    oZone = new Zone();
                    oZone.DeSerialize(m_oSession,sZoneSerialized);
                    if (m_oSession.ReceivingZones[nZoneIdx] == null)
                    {
                        m_oSession.ReceivingZones[nZoneIdx] = oZone;
                        m_oSession.Zones.Add(oZone);

                        //Hide our menus
                        if (m_nGameState == enumStates.LobbyWaitingForSessionToStart)
                        {
                            CheckIfCanJoinSessionNow();
                        }
                    }
                }
				else if( oPacket.MsgType == (int)enumNetMsg.SessionUpdate )
				{
					//ComplexEntity oOurShip = null;
					string sGUID = "";
					string sSession = "";

                    m_oGameEngine.WriteToDebug(1, "Receiving Session Update Packet: Param0(" + oPacket.GetParamater(0) + ") Param1(" + oPacket.GetParamater(1) + ")");

					m_dtTimeSinceLastSessionUpdate = DateTime.Now;

                    m_oGameEngine.WriteToDebug(1, "Receiving Session - NetMsg.Rcv_SessionUpdate");
					NetMsg.Rcv_SessionUpdate( oPacket,ref sGUID,ref sSession );
                    m_oGameEngine.WriteToDebug(1, "Receiving Session - NetMsg.Rcv_SessionUpdate Done");

					//Claim our session
                    m_oGameEngine.WriteToDebug(1, "Receiving Session - Searching for session");
                    Globals.Inst().GameEngine = m_oGameEngine;
                    Globals.Inst().Profile = m_oProfile;
					if( m_oSession == null )
					{
                        m_oGameEngine.WriteToDebug(1, "Receiving Session - Making a new session");
						m_oSession = new Session();
                        Globals.Inst().Session = m_oSession;
						Globals.Inst().Session.LaunchResumeMenu += new EventHandler( LaunchResumeMenu );
					}
                    m_oSession.HaveReceivedSession = true;

                    m_oGameEngine.WriteToDebug(1, "Receiving Session - Deserializing the session");
					m_oSession.DeSerialize( sSession );
                    m_oGameEngine.WriteToDebug(1, "Receiving Session - Done Deserializing the session");

					//Hide our menus
                    if (m_nGameState == enumStates.LobbyWaitingForSessionToStart)
                    {
                        CheckIfCanJoinSessionNow();
                    }

                    m_oGameEngine.WriteToDebug(1, "Receiving Session - Done.");
				}
				else if( oPacket.MsgType == (int)enumNetMsg.EntityUpdate )
				{
					DSSerialize oSerialize = null;
					Entity oEntity = null;
					Entity oSessionEntity = null;
					Location oTempLocation = null;
					string sSerializedStr = "";
					string sPKey = "";                    

					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true )
					{
						//Update the session
						NetMsg.Rcv_EntityUpdate( oPacket,ref sPKey,ref oEntity,ref sSerializedStr );

						oSessionEntity = m_oSession.GetEntity( sPKey );
						if( oSessionEntity == null )
						{
							if( m_oEntitysRemoved.ContainsKey( sPKey ) == false )
							{
								oSerialize = new DSSerialize( sSerializedStr );
                                oEntity.DeSerialize(m_oSession,oSerialize);
								m_oSession.AddEntity( oEntity,false );
							}
						}
						//We keep our ship because if this is our ship, then we are the ultimate-authority.
						else if( oSessionEntity.OwnerSocketID != Globals.Inst().OurShip.OwnerSocketID )
						{
							oTempLocation = new Location( oSessionEntity.Location );

							oSerialize = new DSSerialize( sSerializedStr );
                            oSessionEntity.DeSerialize(m_oSession,oSerialize);
							oSessionEntity.LastServerLocation = new Location( oSessionEntity.Location );
							oSessionEntity.Location = new Location( oTempLocation );
                            m_oSession.ChangeZone(oSessionEntity);
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.EntityLiteUpdate )
				{
					Entity oEntity = null;
					string sEntityGUID = "";
					Location oServerLocation = null;

					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						//Update the session
						NetMsg.Rcv_EntityLiteUpdate( oPacket,ref sEntityGUID,ref oServerLocation );
						oEntity = m_oSession.GetEntity( sEntityGUID );

						if( oEntity != null && oEntity.OwnerSocketID != Globals.Inst().OurShip.OwnerSocketID )
						{
							//has to be a new instance
							oEntity.ServerLocation = new Location( oServerLocation );
							oEntity.LastServerLocation = new Location( oServerLocation );
							oEntity.Location = new Location( oServerLocation );
                            m_oSession.ChangeZone(oEntity);
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.EntityKeyPress )
				{
					Entity oEntity = null;
					Microsoft.DirectX.DirectInput.Key oKey = Key.Escape;
					string sEntityPKey = "";
					bool bPressed = false;
 
					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						//Get our data
						NetMsg.Rcv_EntityKeyPress( oPacket,ref sEntityPKey,ref oKey,ref bPressed );

						//Pass in the ksy stroke
						oEntity = m_oSession.GetEntity( sEntityPKey );
                        if (oEntity != null)
                        {
                            oEntity.KeyProcess(m_oSession,oKey, bPressed);

                            oEntity.Advance(m_oSession,oSendingPlayer.LastPingInSeconds / 2.0f);
                        }
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.Respawn )
				{
					long nSocketIDOfPlayerToRespawn = 0;
					ComplexEntity oOurShip = null;

					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						NetMsg.Rcv_Respawn( oPacket,ref nSocketIDOfPlayerToRespawn );

                        //03/10/2008 Chris Hill  Even if we think we aren't dead, the server does.
						if( nSocketIDOfPlayerToRespawn == m_oGameEngine.DirectPlay.Me.SocketID /*&&
							(
								Globals.Inst().OurShip == null 
								||
								Globals.Inst().OurShip.IsDead == true
							)*/
						  )
						{
							//Mark the old ships as not ours
							Globals.Inst().OurShip.OwnerSocketID = MiscConstants.m_cNOSOCKETIDASSIGNED;

							//Create a new ship
							oOurShip = m_oSession.GetStarterShip();
                            m_oSession.AddEntity(oOurShip, true);
							Globals.Inst().OurShip = oOurShip;
							Globals.Inst().Profile.OurShip = oOurShip;

                            NetMsg.Send_EntityUpdate(m_oGameEngine.DirectPlay, m_oGameEngine.DirectPlay.PlayerWhoIsHost, m_oSession,oOurShip);

							m_oSession.AddChatMsg( null,"You have died!  Respawning." );
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.GameChat )
				{
					long nSenderSocketID = 0;
					string sMessage = "";
					DSNetworkPlayer oPlayer = null;

					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						NetMsg.Rcv_GameChat( oPacket,ref nSenderSocketID,ref sMessage );

						oPlayer = m_oGameEngine.DirectPlay.GetPlayer( nSenderSocketID );

						//And pass on to the rest of the session players
						m_oSession.AddChatMsg( oPlayer,sMessage );
					}
				}
                else if (oPacket.MsgType == (int)enumNetMsg.EntityReceivesEXP )
                {
					Entity oEntity = null;
					string sEntityPKey = "";
					long nAmountOfEXP = 0;

					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						NetMsg.Rcv_EntityReceivesEXP( oPacket,ref sEntityPKey,ref nAmountOfEXP );

						oEntity = (Entity)m_oSession.GetEntity( sEntityPKey );
						if( oEntity != null )
						{
							m_oSession.GiveExpToEntity( oEntity,nAmountOfEXP );
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.EntityReceivesLoot )
				{
					Skin oSkin = null;
					Item oLootItem = null;
					Chassis oChassis = null;
					Module oModule = null;
					int nPage = 0;
					long nSocketIDOfPlayerToGetLoot = 0;


					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						NetMsg.Rcv_EntityReceivesLoot( oPacket,m_oSession,ref nSocketIDOfPlayerToGetLoot,ref oLootItem );

						if( nSocketIDOfPlayerToGetLoot == m_oGameEngine.DirectPlay.Me.SocketID &&
							(
								Globals.Inst().OurShip == null 
								||
								Globals.Inst().OurShip.IsDead == false
							)
						  )
						{
							if( Globals.ObjectIsModule( oLootItem ) == true )
							{
								oModule = (Module)oLootItem;
								if( Globals.Inst().Profile.UnassignedModules.ContainsKey( oModule.PKey ) == false )
								{
									nPage = Globals.Inst().Profile.FindOpenModuleInventoryPage();
									oModule.XOffset = nPage * 6;
									Globals.Inst().Profile.UnassignedModules.Add( oModule.PKey,oModule );
								}
							}
							else if( Globals.ObjectIsChassis( oLootItem ) == true )
							{
								oChassis = (Chassis)oLootItem;
								if( Globals.Inst().Profile.UnassignedChassis.ContainsKey( oChassis.PKey ) == false )
								{
									nPage = Globals.Inst().Profile.FindOpenChassisInventoryPage();
									oChassis.XOffset = nPage * 12;
									Globals.Inst().Profile.UnassignedChassis.Add( oChassis.PKey,oChassis );
								}
							}
							else if( oLootItem.GetType() == typeof( Skin ) )
							{
								oSkin = (Skin)oLootItem;
								if( Globals.Inst().Profile.UnassignedSkins.ContainsKey( oSkin.PKey ) == false )
								{
									Globals.Inst().Profile.UnassignedSkins.Add( oSkin.PKey,oSkin );
								}
							}
							else
							{
								throw new System.Exception( "Unknown loot type received." );
							}

							Globals.Inst().Session.AddRollingText( 
								Globals.Inst().OurShip.Pos,Globals.Inst().OurShip.Vel,
								"+1 Loot (" + oLootItem.Name + ")",System.Drawing.Color.Green );
                            Globals.PlaySound(SoundConstants.m_cPICKEDUPLOOT, Globals.Inst().OurShip.Location);
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.EntityRemoveChassis )
				{
					ComplexEntity oCEntity = null;
					Chassis oChassis = null;
					string sEntityGUID = "";
					string sChassisToRemoveGUID = "";

					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						NetMsg.Rcv_EntityRemoveChassis( oPacket,ref sEntityGUID,ref sChassisToRemoveGUID );

						oCEntity = (ComplexEntity)m_oSession.GetEntity( sEntityGUID );
						if( oCEntity != null )
						{
							oChassis = (Chassis)oCEntity.Chasses.GetByKey( sChassisToRemoveGUID );
							if( oChassis != null )
							{
								oCEntity.RemoveChassis( oChassis );
						
								if( m_oSession.UnassignedChassis.ContainsKey( oChassis.PKey ) == false )
								{
									m_oSession.UnassignedChassis.Add( oChassis.PKey,oChassis );
								}
							}
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.SetEntityInPlayStatus  )
				{
					bool bIsInPlayFlag = false;
					string sEntityGUID = "";
					Entity oEntity = null;

					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						NetMsg.Rcv_SetEntityInPlayStatus( oPacket,ref sEntityGUID,ref bIsInPlayFlag );

						oEntity = m_oSession.GetEntity( sEntityGUID );
                        if (oEntity != null)
                        {
                            oEntity.IsInPlay = bIsInPlayFlag;
                        }
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.EntityMessage )
				{
					string sEntityPKey = "";
					string sIncomingMessage = "";
					long nSubMessageType = 0;
					Entity oEntity = null;

					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						NetMsg.Rcv_EntityMessage( oPacket,ref sEntityPKey,ref nSubMessageType,ref sIncomingMessage );

						oEntity = m_oSession.GetEntity( sEntityPKey );
                        oEntity.NetworkMessageReceived(m_oSession, nSubMessageType, sIncomingMessage);
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.RemoveEntity )
				{
					string sEntityPKey = "";
					Entity oEntity = null;

					//If we don't have a session then updates aren't needed
                    if (SessionIsActive() == true)
					{
						NetMsg.Rcv_RemoveEntity( oPacket,ref sEntityPKey );

						if( m_oEntitysRemoved.ContainsKey( sEntityPKey ) == false )
						{
							m_oEntitysRemoved.Add( sEntityPKey,null );
						}
						oEntity = m_oSession.GetEntity( sEntityPKey );
						if( oEntity != null )
						{
							Globals.Inst().Session.RemoveEntity( oEntity );
						}
					}
				}
				else if( oPacket.MsgType == (int)enumNetMsg.RollingText )
				{
					/*Vector2 vPos = Vector2.Empty;
					Vector2 vVel = Vector2.Empty;
					int nColor = 0;
					string sMsg = string.Empty;

					if( Globals.Inst().Session != null )
					{
						NetMsg.Rcv_RollingText( oPacket,ref vPos,ref vVel,ref nColor,ref sMsg );

						Globals.Inst().Session.AddRollingText( vPos,vVel,
							sMsg,System.Drawing.Color.FromArgb( nColor ) );
					}*/
				}
				#endregion

				/*else if( m_oSession != null && m_oSession.WaveManager.DataReceived( oSendingPlayer,oPacket ) == true )
				{
					//The datareceived call took care of handling the data so there is nothing to do
					m_oSession.WaveManager.DataReceived( oSendingPlayer,oPacket );
				}*/
			}
			catch( System.Exception oEx )
			{
                m_oGameEngine.WriteToDebug(1, "Error On DataReceive(" + n1i.ToString() + "): " + oEx.Message + "\n[" + oEx.StackTrace + "]");
				DSMisc.ShowErrors( oEx );
			}
		}
		private void PlayerJoined( DSNetworkPlayer oNewPlayer,bool bUs )
		{
            m_oGameEngine.WriteToDebug(1, "Player " + oNewPlayer.Name + " joined.");

			if( oNewPlayer.IAmHost == true )
			{
				m_bHostHasJoined = true;
			}
			else
			{
				//Add them to the list
				AddChatLobbyUser( oNewPlayer );

				if( bUs == true )
				{
					Globals.Inst().PrimaryKey = new DSNetPrimaryKeyGenerator( oNewPlayer.SocketID );
					m_oProfile.UpdateProfilePKeyWithSocketID( oNewPlayer.SocketID );
					m_bIHaveJoined = true;
				}
			}

			if( m_bHostHasJoined == true && m_bIHaveJoined == true )
			{
                m_oGameEngine.WriteToDebug(2, "Sytem - Both I and host have joined");

				//Now that were in the game... send our version request
				NetMsg.Send_IsPatchAvailable( m_oGameEngine.DirectPlay,Application.ProductVersion );

				NetMsg.Send_RequestingSessionList( m_oGameEngine.DirectPlay,m_oGameEngine.DirectPlay.PlayerWhoIsHost );
				NetMsg.Send_RequestingPlayerList( m_oGameEngine.DirectPlay,m_oGameEngine.DirectPlay.PlayerWhoIsHost );
			}
			else
			{
				if( m_bHostHasJoined == false )
				{
                    m_oGameEngine.WriteToDebug(2,"System - Still waiting for host to join");
				}
				if( m_bIHaveJoined == false )
				{
                    m_oGameEngine.WriteToDebug(2,"System - Still waiting for me to join");
				}
			}
		}
		private void PlayerQuit( DSNetworkPlayer oLeavingPlayer )
		{
			string sGUID = "";


            m_oGameEngine.WriteToDebug(1, "Player " + oLeavingPlayer.Name + " quit.");

			//Was this player in a game?
			if( m_oPlayerSocketIDToSessionGUIDLookup.ContainsKey( oLeavingPlayer.SocketID ) == true )
			{
				sGUID = (string)m_oPlayerSocketIDToSessionGUIDLookup.GetByKey( oLeavingPlayer.SocketID );
				m_oSession.RemovePlayer( oLeavingPlayer );
			}

			DelChatLobbyUser( oLeavingPlayer );
		}
		private void Connection( Microsoft.DirectX.DirectPlay.ResultCode oCode,string sDescription,bool bConnectionSuccessful )
		{
			if( bConnectionSuccessful == true )
			{				
				StartChatLobby( false );
				SwitchMenus( MenuConstants.m_cMENU_WAITTOCONNECT,MenuConstants.m_cMENU_CHATLOBBY );
			}
			else
			{
				if( m_nGameState == enumStates.InGame )
				{
					MessageBox.Show( "Connection to server lost: " + sDescription );

					m_oSession = null;
					m_nGameState = enumStates.MainMenu;
					StartMainForm( false );
					SwitchMenus( "",MenuConstants.m_cMENU_MAIN );
				}
				else
				{
					MessageBox.Show( "Connect failed: " + sDescription );
				}
			}
		}
		private void GameListUpdate( FindHostsResponseInformation dpGameInfo )
		{
			m_oGameEngine.DirectPlay.CancelGameSearch();
			m_oGameEngine.DirectPlay.JoinGame( dpGameInfo,m_oProfile.Name );
		}

        private bool SessionIsActive()
        {
            int nMissingZones = 0;
            //ComplexEntity oOurShip = null;


            //How many missing zones do we have?
            foreach( Zone oLoopZone in m_oSession.ReceivingZones )
            {
                if( oLoopZone == null )
                {
                    nMissingZones++;
                }
            }

            if (m_oSession.HaveReceivedSession == true && m_oSession.ReceivingZones.Count > 0 && nMissingZones == 0)
            {
                return (true);
            }
            else
            {
                return (false);
            }
        }
        private void CheckIfCanJoinSessionNow()
        {
            int nMissingZones = 0;
            double nPerc = 0;
            ComplexEntity oOurShip = null;


            if (SessionIsActive() == true)
            {
                if (m_oProfile.OurShip == null)
                {
                    oOurShip = m_oSession.GetStarterShip();
                }
                else
                {
                    oOurShip = m_oProfile.OurShip;
                }
                m_oProfile.OurShip = oOurShip;
                oOurShip.AngularMomentum = 0;
                //oOurShip.Angle = 6.10;
                oOurShip.Angle = 0;
                oOurShip.OwnerSocketID = m_oGameEngine.DirectPlay.Me.SocketID;
                oOurShip.Vel = new Vector2(0, 0);
                //oOurShip.Pos = new Vector2( DSMisc.GetRnd( -2000,2000 ),DSMisc.GetRnd( -2000,2000 ) );
                oOurShip.Pos = new Vector2(
                    (float)DSMisc.GetRnd(-Globals.Inst().Session.Width / 2.0, Globals.Inst().Session.Width / 2.0),
                    (float)DSMisc.GetRnd(-Globals.Inst().Session.Height / 2.0, Globals.Inst().Session.Height / 2.0));

                m_oSession.Zones.Values[0].AddEntity(m_oSession, oOurShip, false);
                Globals.Inst().OurShip = oOurShip;

                m_oGameEngine.Forms.GetForm(MenuConstants.m_cMENU_WAITTOCONNECT).Visible = false;
                SwitchMenus(MenuConstants.m_cMENU_CHATLOBBY, "");
                m_nGameState = enumStates.InGame;

                NetMsg.Send_EntityUpdate(m_oGameEngine.DirectPlay, m_oGameEngine.DirectPlay.PlayerWhoIsHost, m_oSession, oOurShip);
            }
            else
            {
                //How many missing zones do we have?
                foreach( Zone oLoopZone in m_oSession.ReceivingZones )
                {
                    if( oLoopZone == null )
                    {
                        nMissingZones++;
                    }
                }
                if (m_oSession.ReceivingZones.Count > 0)
                {
                    nPerc = 1 - ((double)nMissingZones / (double)m_oSession.ReceivingZones.Count);
                }
                else
                {
                    nPerc = 0;
                }
                UpdateWaitingToJoinPerc(nPerc);
            }
        }

		private void GetServerIP( ref string sIP,ref int nPort )
		{
			DSGobTable oGobTable = null;

			//Get our stats
			oGobTable = DSResourceManager.GetGlobalInstance().GetGobTable( GobConstants.m_cTABLE_SETTINGS );
			sIP = (string)oGobTable.FindValue( 0,GobConstants.m_cSETTING_SERVERIP );
			nPort = (int)oGobTable.FindValue( 0,GobConstants.m_cSETTING_SERVERPORT );
		}
		private void ConnectToServer( string sIP,int nPort )
		{
			m_oGameEngine.DirectPlay.JoinGame( m_oProfile.Name,sIP,nPort );

			//Now start the waiting game
			StartWaitingToConnect( false );
			SwitchMenus( MenuConstants.m_cMENU_SELPROFILE,MenuConstants.m_cMENU_WAITTOCONNECT );
		}
		#endregion


		#region Properties
		public DSGameEngine DSGameEngine
		{
			get
			{
				return( m_oGameEngine );
			}
			set
			{
				m_oGameEngine = value;
			}
		}
		#endregion
	}


	public enum enumStates
	{
		LoadingApp,
		SplashScreen,
		LoadingGobs,
		FadingLoadingScreen,
		FadingInMainMenu,
		MainMenu,
		LobbyWaitingForSessionToStart,
		InGame,
		ResumeMenu
	};
}